/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.KoalaConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class KoalaEntity
extends Animal
implements ILexiconEntry {
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(KoalaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public KoalaEntity(EntityType<? extends KoalaEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)ModEntityTypes.KOALA.get().m_20615_((Level)world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, KoalaConfig.health()).m_22268_(Attributes.f_22279_, KoalaConfig.movementSpeed());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredients.KOALA_FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.setBesideClimbableBlock(this.f_19862_);
        }
    }

    public static boolean checkKoalaSpawnRules(EntityType<KoalaEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.KOALA_SPAWNABLE_ON) && KoalaEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.KOALA_FOOD);
    }

    public int m_5792_() {
        return KoalaConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.8f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return (int)((double)super.m_5639_(distance, damageMultiplier) * 0.5);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.KOALA;
    }
}

